/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.sales.service;

import itx.erp.sales.model.SlotitemDay;
import itx.erp.sales.model.SlotitemHour;
import itx.erp.sales.model.SlotitemMonth;
import itx.erp.sales.model.SlotitemWeek;
import itx.erp.sales.model.Slotplan;
import itx.erp.sales.model.SlotplanPricetype;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import jtbcore.exception.JTBException;
import jtbcore.model.BaseStringMap;
import jtbcore.model.BaseStringMapObject;
import jtbcore.service.ServiceBase;

public class SlotService
extends ServiceBase {
    public Slotplan readSlotplan(Integer slotplanId) throws SQLException, JTBException {
        SlotplanPricetype spt;
        SlotplanPricetype spt2;
        Slotplan p = (Slotplan)this.queryToObject(Slotplan.class, "select * from sales__slotplan where slotplan_id = ?", slotplanId);
        List l = this.queryToList(SlotitemHour.class, "select * from sales__slotitem_hour where slotplan_id = ?", slotplanId);
        p.setSlotitemHours(l);
        List days = this.queryToList(SlotitemDay.class, "select * from sales__slotitem_day sd where slotplan_id = ?", slotplanId);
        p.setSlotitemDays(days);
        List weeks = this.queryToList(SlotitemWeek.class, "select * from sales__slotitem_week sw where slotplan_id = ? order by weekno", slotplanId);
        p.setSlotitemWeeks(weeks);
        List months = this.queryToList(SlotitemMonth.class, "select * from sales__slotitem_month sm where slotplan_id = ? order by monthno", slotplanId);
        p.setSlotitemMonths(months);
        ArrayList<SlotplanPricetype> pricetypes = new ArrayList<SlotplanPricetype>();
        ArrayList<Integer> pricetypeIds = new ArrayList<Integer>();
        if ("hour".equals(p.getDefaultSlotType())) {
            for (SlotitemHour sh : l) {
                if (pricetypeIds.contains(sh.getSlotplanPricetypeId()) || sh.getSlotplanPricetypeId() == null) continue;
                spt2 = this.readPricetype(sh.getSlotplanPricetypeId());
                pricetypes.add(spt2);
                pricetypeIds.add(sh.getSlotplanPricetypeId());
            }
        }
        if ("day".equals(p.getDefaultSlotType())) {
            for (SlotitemDay sd : days) {
                if (pricetypeIds.contains(sd.getSlotplanPricetypeId()) || (spt2 = this.readPricetype(sd.getSlotplanPricetypeId())) == null || !spt2.isActive().booleanValue()) continue;
                pricetypes.add(spt2);
                pricetypeIds.add(sd.getSlotplanPricetypeId());
            }
        }
        if ("week".equals(p.getDefaultSlotType())) {
            spt = this.readPricetype(p.getPricetypeIdWeek());
            pricetypes.add(spt);
        }
        if ("month".equals(p.getDefaultSlotType())) {
            spt = this.readPricetype(p.getPricetypeIdMonth());
            pricetypes.add(spt);
        }
        p.setPricetypes(pricetypes);
        return p;
    }

    public List<Slotplan> listSlotplans() throws SQLException, JTBException {
        List l = this.queryToList(Slotplan.class, "select * from sales__slotplan", new Object[0]);
        ArrayList<Slotplan> r = new ArrayList<Slotplan>();
        for (Slotplan sp : l) {
            Slotplan p = this.readSlotplan(sp.getSlotplanId());
            r.add(p);
        }
        return r;
    }

    public void saveSlotplan(Slotplan p) throws IOException, SQLException {
        Integer siId;
        BaseStringMapObject si;
        Integer oldId;
        Integer id = this.connection.save("sales__slotplan", "slotplan_id", p.getBaseStringMap());
        p.setSlotplanId(id);
        List<BaseStringMap> bsms = this.connection.queryBsmList("select * from sales__slotitem_hour where slotplan_id = ?", p.getSlotplanId());
        int x = 0;
        while (x < p.getSlotitemHours().size()) {
            oldId = null;
            if (x < bsms.size()) {
                oldId = bsms.get(x).getPropertyInt("slotitem_hour_id");
            }
            si = p.getSlotitemHours().get(x);
            ((SlotitemHour)si).setSlotitemHourId(oldId);
            ((SlotitemHour)si).setSlotplanId(p.getSlotplanId());
            siId = this.connection.save("sales__slotitem_hour", "slotitem_hour_id", si);
            ((SlotitemHour)si).setSlotitemHourId(siId);
            ++x;
        }
        while (x < bsms.size()) {
            this.connection.query("delete from sales__slotitem_hour where slotitem_hour_id = ?", bsms.get(x).getPropertyInt("slotitem_hour_id"));
            ++x;
        }
        bsms = this.connection.queryBsmList("select * from sales__slotitem_day where slotplan_id = ?", p.getSlotplanId());
        x = 0;
        while (x < p.getSlotitemDays().size()) {
            oldId = null;
            if (x < bsms.size()) {
                oldId = bsms.get(x).getPropertyInt("slotitem_day_id");
            }
            si = p.getSlotitemDays().get(x);
            ((SlotitemDay)si).setSlotitemDayId(oldId);
            ((SlotitemDay)si).setSlotplanId(p.getSlotplanId());
            siId = this.connection.save("sales__slotitem_day", "slotitem_day_id", si);
            ((SlotitemDay)si).setSlotitemDayId(siId);
            ++x;
        }
        while (x < bsms.size()) {
            this.connection.query("delete from sales__slotitem_day where slotitem_day_id = ?", bsms.get(x).getPropertyInt("slotitem_day_id"));
            ++x;
        }
        bsms = this.connection.queryBsmList("select * from sales__slotitem_week where slotplan_id = ?", p.getSlotplanId());
        x = 0;
        while (x < p.getSlotitemWeeks().size()) {
            oldId = null;
            if (x < bsms.size()) {
                oldId = bsms.get(x).getPropertyInt("slotitem_week_id");
            }
            SlotitemWeek sw = p.getSlotitemWeeks().get(x);
            sw.setSlotitemWeekId(oldId);
            sw.setSlotplanId(p.getSlotplanId());
            siId = this.connection.save("sales__slotitem_week", "slotitem_week_id", sw);
            sw.setSlotitemWeekId(siId);
            ++x;
        }
        while (x < bsms.size()) {
            this.connection.query("delete from sales__slotitem_week where slotitem_week_id = ?", bsms.get(x).getPropertyInt("slotitem_week_id"));
            ++x;
        }
        bsms = this.connection.queryBsmList("select * from sales__slotitem_month where slotplan_id = ?", p.getSlotplanId());
        x = 0;
        while (x < p.getSlotitemMonths().size()) {
            oldId = null;
            if (x < bsms.size()) {
                oldId = bsms.get(x).getPropertyInt("slotitem_month_id");
            }
            SlotitemMonth sm = p.getSlotitemMonths().get(x);
            sm.setSlotitemMonthId(oldId);
            sm.setSlotplanId(p.getSlotplanId());
            siId = this.connection.save("sales__slotitem_month", "slotitem_month_id", sm);
            sm.setSlotitemMonthId(siId);
            ++x;
        }
        while (x < bsms.size()) {
            this.connection.query("delete from sales__slotitem_month where slotitem_month_id = ?", bsms.get(x).getPropertyInt("slotitem_month_id"));
            ++x;
        }
    }

    public void deleteSlotplan(Integer slotplanId) throws SQLException {
        this.connection.query("delete from sales__slotitem_hour where slotplan_id = ?", slotplanId);
        this.connection.query("delete from sales__slotplan where slotplan_id = ?", slotplanId);
    }

    public List<SlotplanPricetype> readPricetypes() throws SQLException, JTBException {
        List l = this.queryToList(SlotplanPricetype.class, "select * from sales__slotplan_pricetype order by sort", new Object[0]);
        return l;
    }

    public SlotplanPricetype readPricetype(Integer id) throws SQLException, JTBException {
        SlotplanPricetype p = (SlotplanPricetype)this.queryToObject(SlotplanPricetype.class, "select * from sales__slotplan_pricetype where slotplan_pricetype_id = ?", id);
        return p;
    }

    public Integer savePricetype(SlotplanPricetype p) throws SQLException, JTBException, IOException {
        Integer id = this.connection.save("sales__slotplan_pricetype", "slotplan_pricetype_id", p.getBaseStringMap());
        p.setSlotplanPricetypeId(id);
        return id;
    }

    public void deletePricetype(Integer id) throws SQLException {
        this.connection.query("delete from sales__slotplan_pricetype where slotplan_pricetype_id = ?", id);
    }

    public void updatePricetypeSort(List<Integer> ids) throws SQLException {
        int x = 0;
        while (x < ids.size()) {
            this.connection.query("update sales__slotplan_pricetype set sort = ? where slotplan_pricetype_id = ?", x, ids.get(x));
            ++x;
        }
    }

    public List<Slotplan> readSlotplanByArticles(List<Integer> articleIds) throws SQLException, JTBException {
        if (articleIds.size() == 0) {
            return new ArrayList<Slotplan>();
        }
        StringBuffer buf = new StringBuffer();
        buf.append("select distinct slotplan_id from sales__article where pricing_method='slotplan' and article_id in ( ");
        int x = 0;
        while (x < articleIds.size()) {
            if (x > 0) {
                buf.append(", ");
            }
            buf.append(articleIds.get(x));
            ++x;
        }
        buf.append(")");
        List<BaseStringMap> slotplanIds = this.connection.queryBsmList(buf.toString(), new Object[0]);
        ArrayList<Slotplan> sps = new ArrayList<Slotplan>();
        for (BaseStringMap bsm : slotplanIds) {
            Integer spid = bsm.getPropertyInt("slotplan_id");
            Slotplan sp = this.readSlotplan(spid);
            sps.add(sp);
        }
        return sps;
    }
}

